﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample5
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern bool DeleteObject(IntPtr hObject);

        [Flags]
        public enum PenStyle
        {
            PS_Solid = 0,
            PS_Dash = 1,
            PS_Dot = 2,
            PS_DashDot = 3,
            PS_DashDotDot = 4,
            PS_Null = 5,
            PS_InSideFrame = 6,
            PS_UserStyle = 7,
            PS_Alternate = 8,
            PS_StyleMask = 0x0000000F,

            PS_EndCapRound = 0x00000000,
            PS_EndCapSquare = 0x00000100,
            PS_EndCapFlat = 0x00000200,
            PS_EndCapMask = 0x00000F00,

            PS_JoinRound = 0x00000000,
            PS_JoinBevel = 0x00001000,
            PS_JoinMiter = 0x00002000,
            PS_JoinMask = 0x0000F000,

            PS_CosMetric = 0x00000000,
            PS_GeoMetric = 0x00010000,
            PS_TypeMask = 0x000F0000
        }

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePen(PenStyle penStyle, int nWidth, int penColor);

        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(IntPtr hDC, IntPtr hObject);

        [DllImport("gdi32.dll")]
        public static extern bool Rectangle(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateRoundRectRgn(int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nWidth, int nHeight);

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateHatchBrush(CreateHatchBrushType fnStyle, int crColor);

        public enum CreateHatchBrushType
        {
            HS_BDiagonal = 0x3,
            HS_Cross = 0x4,
            HS_DiagonalCross = 0x5,
            HS_FDiagonal = 0x2,
            HS_Horizontal = 0x0,
            HS_Vertical = 0x1
        }

        [DllImport("gdi32.dll")]
        public static extern bool FillRgn(IntPtr hDC, IntPtr hRgn, IntPtr hBrush);

        [DllImport("gdi32.dll")]
        public static extern bool FloodFill(IntPtr hDC, int nXStart, int nYStart, int colorFill);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonDraw_Click(object sender, EventArgs e)
        {
            IntPtr hDC = GetDC(this.Handle);
            IntPtr hPen = CreatePen(PenStyle.PS_Solid, 5, ColorTranslator.ToWin32(Color.Blue));
            SelectObject(hDC, hPen);
            Rectangle(hDC, 20, 20, 150, 150);
            Rectangle(hDC, 100, 100, 200, 200);
            IntPtr hBrush = CreateHatchBrush(CreateHatchBrushType.HS_DiagonalCross, ColorTranslator.ToWin32(Color.Green));
            IntPtr rgn = CreateRoundRectRgn(210, 50, 380, 180, 50, 50);
            FillRgn(hDC, rgn, hBrush);

            SelectObject(hDC, hBrush);
            FloodFill(hDC, 30, 30, ColorTranslator.ToWin32(Color.Blue));

            DeleteObject(hPen);
            DeleteObject(hBrush);
        }
    }
}